/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class ProdosOrder
extends ImageOrder {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int[] blockInterleave = new int[]{0, 7, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0, 7};
    private static final int[] blockOffsets = new int[]{0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1};

    public ProdosOrder(ByteArrayImageLayout diskImageManager) {
        super(diskImageManager);
    }

    @Override
    public boolean isBlockDevice() {
        return true;
    }

    @Override
    public boolean isTrackAndSectorDevice() {
        return false;
    }

    @Override
    public byte[] readBlock(int block) {
        return this.readBytes(block * 512, 512);
    }

    @Override
    public void writeBlock(int block, byte[] data) {
        this.writeBytes(block * 512, data);
    }

    @Override
    public byte[] readSector(int track, int sector) throws IllegalArgumentException {
        int block = track * 8 + blockInterleave[sector];
        byte[] blockData = this.readBlock(block);
        int offset = blockOffsets[sector];
        byte[] sectorData = new byte[256];
        System.arraycopy(blockData, offset * 256, sectorData, 0, 256);
        return sectorData;
    }

    @Override
    public void writeSector(int track, int sector, byte[] bytes) throws IllegalArgumentException {
        int block = track * 8 + blockInterleave[sector];
        byte[] blockData = this.readBlock(block);
        int offset = blockOffsets[sector];
        System.arraycopy(bytes, 0, blockData, offset * 256, bytes.length);
        this.writeBlock(block, blockData);
    }

    @Override
    public String getName() {
        return this.textBundle.get("ProdosOrder.OrderName");
    }
}

